//Caption: Periodogram Estimate of Given Discrete Sequence 
//x(n) ={1,0,2,0,3,1,0,2}
//using DFT
clear;
clc;
close;
N =8; //8-point DFT
x = [1,0,2,0,3,1,0,2]; //given discrete sequence
X = dft(x,-1); //8-point DFT of given discrete sequence
Pxx = (1/N)*(abs(X).^2); //Peridogram Estimate 
disp(X,'DFT of x(n)is X(k)=')
disp(Pxx,'Peridogram of x(n) is Pxx(k/N)=')
figure(1)
a = gca();
a.data_bounds =[0,0;8,11];
plot2d3('gnn',[1:N],Pxx)
a.foreground = 5; 
a.font_color = 5;
a.font_style = 5;
title('Peridogram Estimate')
xlabel('Discrete Frequency Variable K ----->')
ylabel('Periodogram Pxx (k /N) ---->')
//Result
//DFT of x(n)is X(k)=   
// 
//    9.                      
//  - 1.2928932 + 0.1213203i  
//    2. + i                  
//  - 2.7071068 + 4.1213203i  
//    3. - 3.674D-16i         
//  - 2.7071068 - 4.1213203i  
//    2. - i                  
//  - 1.2928932 - 0.1213203i  
// 
// Peridogram of x(n) is Pxx(k/N)=   
// 
//    10.125     
//    0.2107864  
//    0.625      
//    3.0392136  
//    1.125      
//    3.0392136  
//    0.625      
//    0.2107864  